<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><?= $title ?? 'Inmobiliaria Huánuco' ?></title>

<link rel="stylesheet" href="<?= base_url('assets/css/styles.css') ?>" type="text/css" />
<link rel="stylesheet" href="<?= base_url('assets/css/ajxmenu.css') ?>" type="text/css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
<link href="https://fonts.googleapis.com/css?family=Armata|Istok+Web|Pontano+Sans|Quattrocento|Tenali+Ramakrishna" rel="stylesheet"> 

<style type="text/css">
    .bodyTable {
        font-family: 'Istok Web', sans-serif;
        font-size: 14px;
    }
    .whatsapp-link {
        text-decoration: none;
        color: inherit;
    }
    .whatsapp-logo {
        width: 40px;
        height: 40px;
    }
</style>

<script src="https://code.jquery.com/jquery-1.8.3.min.js" integrity="sha256-YcbK69I5IXQftf/mYD8WY0/KmEDCv1asggHpJk1trM8=" crossorigin="anonymous"></script>
<script type="text/javascript" src="<?= base_url('assets/js/ajxmenu.js') ?>"></script>

<script type="text/javascript">
    $(document).ready(function() {
        $("a.zoom").fancybox({
            'transitionIn': 'elastic',
            'transitionOut': 'elastic'
        });
    });
    
    function verInmueble(id) {
        document.location.href = '<?= base_url('inmueble') ?>/' + id;
    }
    
    function abrir_ventana(codigo) {
        var opciones = "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=650, height=450, top=85, left=140";
        window.open("<?= base_url('ficha') ?>/" + codigo, "", opciones);
    }
</script>
</head>

<body>

<?= $this->include('layouts/header') ?>

<div class="divBody">
    <?= $this->renderSection('content') ?>
</div>

<div class="divEnlaces"></div>

<div class="divFooter">
    <?= $this->include('layouts/footer') ?>
</div>

<script>
const whatsappLinks = document.querySelectorAll('.whatsapp-link');

whatsappLinks.forEach(link => {
    link.addEventListener('click', function(event) {
        const defaultMessage = "Hola, estoy interesado en el inmueble: " + this.dataset.inmueble + ', ubicado en: ' + this.dataset.ubigeo;

        // Detectar si es móvil o escritorio
        const isMobile = /Android|iPhone|iPad|iPod/i.test(navigator.userAgent);

        // Generar la URL correcta
        const whatsappUrl = isMobile
            ? `whatsapp://send?phone=+51962524274&text=${encodeURIComponent(defaultMessage)}`
            : `https://web.whatsapp.com/send?phone=+51962524274&text=${encodeURIComponent(defaultMessage)}`;

        // Redirigir al usuario a WhatsApp
        window.location.href = whatsappUrl;
    });
});      
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
