<?php

namespace App\Models;

use CodeIgniter\Model;

class ConfiguracionModel extends Model
{
    protected $table = 'configuracion';
    protected $primaryKey = 'configuracion';
    protected $useAutoIncrement = false;
    protected $returnType = 'array';
    protected $useSoftDeletes = false;
    protected $protectFields = true;
    protected $allowedFields = ['configuracion', 'valor', 'descripcion'];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat = 'datetime';

    // Validation
    protected $validationRules = [];
    protected $validationMessages = [];
    protected $skipValidation = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;

    /**
     * Obtener valor de configuración
     */
    public function getConfiguracion($configuracion)
    {
        $result = $this->where('configuracion', $configuracion)->first();
        return $result ? $result['valor'] : null;
    }

    /**
     * Obtener texto de configuración
     */
    public function getTextoConfiguracion($id = 1)
    {
        $db = \Config\Database::connect();
        $query = $db->table('configuraciontexto')
                    ->select('texto')
                    ->where('id', $id)
                    ->get();
        
        $result = $query->getRow();
        return $result ? $result->texto : '';
    }
}
