# Inmobiliaria Huánuco - CodeIgniter 4

Este es el proyecto modernizado de la Inmobiliaria Huánuco, migrado de PHP 5.x a CodeIgniter 4 con PHP 8 y MySQL 8.

## Características

- ✅ **Framework**: CodeIgniter 4.6.3
- ✅ **PHP**: 8.0+
- ✅ **Base de datos**: MySQL 8
- ✅ **Diseño**: Replica exacta del diseño original
- ✅ **Funcionalidad**: Listado de inmuebles con paginación

## Estructura del Proyecto

```
civ4/
├── app/
│   ├── Controllers/
│   │   └── Home.php              # Controlador principal
│   ├── Models/
│   │   ├── InmuebleModel.php     # Modelo de inmuebles
│   │   └── ConfiguracionModel.php # Modelo de configuración
│   ├── Views/
│   │   ├── layouts/
│   │   │   ├── main.php          # Layout principal
│   │   │   ├── header.php        # Header
│   │   │   ├── footer.php        # Footer
│   │   │   ├── menu.php          # Menú de navegación
│   │   │   ├── leftBody.php      # Panel izquierdo
│   │   │   └── rightBody.php     # Panel derecho
│   │   └── home/
│   │       └── index.php         # Vista principal
│   ├── Helpers/
│   │   └── inmueble_helper.php   # Helper para inmuebles
│   └── Config/
│       ├── Database.php          # Configuración de BD
│       └── Routes.php            # Rutas
├── public/
│   ├── assets/
│   │   ├── css/                  # Estilos CSS
│   │   ├── js/                   # JavaScript
│   │   └── images/               # Imágenes
│   └── .htaccess                 # Configuración Apache
└── README.md
```

## Configuración

### Base de Datos

La configuración de la base de datos está en `app/Config/Database.php`:

```php
'hostname' => 'localhost',
'username' => 'inmobili_bd',
'password' => 'inmobiliaria2012',
'database' => 'inmobili_inmobiliaria',
```

### Instalación

1. **Clonar el proyecto**:
   ```bash
   git clone [url-del-repositorio]
   cd civ4
   ```

2. **Instalar dependencias**:
   ```bash
   composer install
   ```

3. **Configurar base de datos**:
   - Importar el archivo SQL: `inmobili_inmobiliaria.sql`
   - Verificar configuración en `app/Config/Database.php`

4. **Configurar servidor web**:
   - Apache/Nginx debe apuntar al directorio `public/`
   - Habilitar mod_rewrite para Apache

## Funcionalidades Implementadas

### ✅ Completado
- [x] Estructura básica de CodeIgniter 4
- [x] Configuración de base de datos MySQL 8
- [x] Modelos para inmuebles y configuración
- [x] Controlador principal con paginación
- [x] Layouts responsivos (header, footer, menú)
- [x] Vista principal con listado de inmuebles
- [x] Sistema de paginación
- [x] Integración con WhatsApp
- [x] Diseño idéntico al original
- [x] Soporte bilingüe (Español/Inglés)

### 🔄 En Progreso
- [ ] Controladores adicionales (Inmueble, Busqueda, etc.)
- [ ] Sistema de búsqueda avanzada
- [ ] Detalle de inmuebles
- [ ] Sistema de contacto
- [ ] Panel de administración

### 📋 Pendiente
- [ ] Sistema de usuarios (Agentes, Propietarios)
- [ ] Panel administrativo
- [ ] Sistema de mensajes
- [ ] Gestión de inmuebles
- [ ] Sistema de destacados
- [ ] Integración con mapas
- [ ] Galería de imágenes

## Tecnologías Utilizadas

- **Backend**: CodeIgniter 4.6.3, PHP 8.0+
- **Base de datos**: MySQL 8
- **Frontend**: HTML5, CSS3, JavaScript, jQuery
- **Frameworks CSS**: Bootstrap 5.1.3
- **Librerías**: Fancybox, Nivo Slider
- **Mapas**: Google Maps API
- **Comunicación**: WhatsApp API

## Mejoras Implementadas

1. **Seguridad**:
   - Protección contra inyección SQL
   - Validación de datos
   - Headers de seguridad

2. **Rendimiento**:
   - Paginación eficiente
   - Consultas optimizadas
   - Caché de consultas

3. **Mantenibilidad**:
   - Código estructurado con MVC
   - Separación de responsabilidades
   - Documentación clara

4. **Escalabilidad**:
   - Arquitectura modular
   - Fácil extensión
   - Configuración flexible

## Desarrollo

### Estructura MVC

- **Models**: Lógica de datos y consultas
- **Views**: Presentación y templates
- **Controllers**: Lógica de negocio y control de flujo

### Convenciones

- Nombres de archivos en PascalCase
- Métodos en camelCase
- Variables en snake_case
- Constantes en UPPER_CASE

## Contribución

1. Fork del proyecto
2. Crear rama para feature (`git checkout -b feature/nueva-funcionalidad`)
3. Commit de cambios (`git commit -am 'Agregar nueva funcionalidad'`)
4. Push a la rama (`git push origin feature/nueva-funcionalidad`)
5. Crear Pull Request

## Licencia

Este proyecto está bajo la licencia MIT. Ver archivo `LICENSE` para más detalles.

## Contacto

- **Desarrollador**: [Tu Nombre]
- **Email**: [tu-email@ejemplo.com]
- **Proyecto**: Inmobiliaria Huánuco CI4